//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "NTAG5Strings.h"

NS_ASSUME_NONNULL_BEGIN

@interface AlmUseCasePage : UIViewController

/* UI VIEWS */
@property (weak, nonatomic)   IBOutlet                      UIView *almConf00View;
@property (weak, nonatomic)   IBOutlet                      UIView *almConf01View;
@property (weak, nonatomic)   IBOutlet                      UIView *almConf02View;
@property (weak, nonatomic)   IBOutlet                      UIView *almConf03View;
@property (weak, nonatomic)   IBOutlet                      UIView *rxResistorValDropDownList;
@property (weak, nonatomic)   IBOutlet                      UIView *rxResistorValHighZOption;
@property (weak, nonatomic)   IBOutlet                      UIView *rxResistorVal300OhmOption;
@property (weak, nonatomic)   IBOutlet                      UIView *rxResistorVal1kOhmOption;
@property (weak, nonatomic)   IBOutlet                      UIView *rxResistorVal2kOhmOption;
@property (weak, nonatomic)   IBOutlet                      UIView *fieldDetectThresholdDropDownList;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold35mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold44mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold53mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold62mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold71mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold80mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold89mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *threshold98mVOption;
@property (weak, nonatomic)   IBOutlet                      UIView *tuningTopologyDropDownList;
@property (weak, nonatomic)   IBOutlet                      UIView *tuninTopology000Option;
@property (weak, nonatomic)   IBOutlet                      UIView *enableResistorDropDownList;
@property (weak, nonatomic)   IBOutlet                      UIView *enableResistorDisabledOption;
@property (weak, nonatomic)   IBOutlet                      UIView *enableResistorEnabledOption;
@property (weak, nonatomic)   IBOutlet                      UIView *txResistorValDropDownList;
@property (weak, nonatomic)   IBOutlet                      UIView *txResistorValHighZOption;
@property (weak, nonatomic)   IBOutlet                      UIView *txResistorVal300OhmOption;
@property (weak, nonatomic)   IBOutlet                      UIView *txResistorVal1kOhmOption;
@property (weak, nonatomic)   IBOutlet                      UIView *txResistorVal2kOhmOption;
@property (weak, nonatomic)   IBOutlet                      UIView *configDropDownList;
@property (strong, nonatomic) IBOutlet                      UIView *mainView;

/* UI IMAGE VIEWS */
@property (weak, nonatomic) IBOutlet                        UIImageView *phaseShiftEnableCheckbox;

/* UI TEXTVIEWS */
@property (weak, nonatomic) IBOutlet                        UITextView *phaseShiftEnabletext;

/* UI TEXTFIELDS */
@property (weak, nonatomic) IBOutlet                        UITextField *staticPhaseOffsetTextField;
@property (weak, nonatomic) IBOutlet                        UITextField *alm3TxResistorValueTextField;
@property (weak, nonatomic) IBOutlet                        UITextField *alm3EnableResistorTextField;
@property (weak, nonatomic) IBOutlet                        UITextField *alm2enableResistorTextField;

/* UI BUTTONS */
@property (weak, nonatomic) IBOutlet                        UIButton *readAlmConfigButton;

/* UI LABELS */
@property (weak, nonatomic) IBOutlet                        UILabel *rxResValLabel;
@property (weak, nonatomic) IBOutlet                        UILabel *fieldDetectThresholdLabel;
@property (weak, nonatomic) IBOutlet                        UILabel *tuningTopologyLabel;
@property (weak, nonatomic) IBOutlet                        UILabel *enableResistorLabel;
@property (weak, nonatomic) IBOutlet                        UILabel *txResistorValLabel;

/* UI SCROLLVIEW */
@property (weak, nonatomic) IBOutlet                        UIScrollView *scrollView;

/* GESTURE & TAP RECOGNIZERS */
- (IBAction)alm01CheckboxTap:                               (UIGestureRecognizer *)sender;
- (IBAction)phaseShiftEnableTextTap:                        (UIGestureRecognizer *)sender;
- (IBAction)rxResValListViewTap:                            (UIGestureRecognizer *)sender;
- (IBAction)thresholdListViewTap:                           (UIGestureRecognizer *)sender;
- (IBAction)tuningTopologyListViewTap:                      (UIGestureRecognizer *)sender;
- (IBAction)rxRestValHighZOptionSelected:                   (UIGestureRecognizer *)sender;
- (IBAction)rxResVal300OhmOptionSelected:                   (UIGestureRecognizer *)sender;
- (IBAction)rxResVal1kOhmOptionSelected:                    (UIGestureRecognizer *)sender;
- (IBAction)rxResVal2kOhmOptionSelected:                    (UIGestureRecognizer *)sender;
- (IBAction)theshold35mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold44mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold53mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold62mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold71mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold80mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold89mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)theshold98mVOptionSelected:                     (UIGestureRecognizer *)sender;
- (IBAction)tuningTopology000OptionSelected:                (UIGestureRecognizer *)sender;
- (IBAction)enableResistorListTap:                          (UIGestureRecognizer *)sender;
- (IBAction)txResistorValueListTap:                         (UIGestureRecognizer *)sender;
- (IBAction)enableResistorDisabledOptionSelected:           (UIGestureRecognizer *)sender;
- (IBAction)enableResistorEmabledOptionSelected:            (UIGestureRecognizer *)sender;
- (IBAction)txRestValHighZOptionSelected:                   (UIGestureRecognizer *)sender;
- (IBAction)txResVal1kOhmOptionSelected:                    (UIGestureRecognizer *)sender;
- (IBAction)txResVal2kOhmOptionSelected:                    (UIGestureRecognizer *)sender;
- (IBAction)txResVal300OhmOptionSelected:                   (id)sender;
- (IBAction)navBarButtonClick:                              (id)sender;
- (IBAction)setI2cSlaveModeOptionSelected:                  (UIGestureRecognizer *)sender;
- (IBAction)setI2cMasterModeOptionSelected:                 (UIGestureRecognizer *)sender;
- (IBAction)setGPIOPWMModeOptionSelected:                   (UIGestureRecognizer *)sender;
- (IBAction):(UIGestureRecognizer *)                        sender;
- (IBAction)readALMConfigButtonClick:                       (UIButton *)sender;
- (void) updateUI:                                          (NSData *) response;

@end

NS_ASSUME_NONNULL_END
